/*
 * Decompiled with CFR 0.152.
 */
package pl.lodz.it.java.gui;

import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pl.lodz.it.java.gui.BoardRowPanel;
import pl.lodz.it.java.gui.FillingJPanel;
import pl.lodz.it.java.gui.MainWindow;
import pl.lodz.it.java.model.Feedback;
import pl.lodz.it.java.model.RowState;

public class GameboardScrollPane
extends JScrollPane {
    private JPanel panel;
    private MainWindow mainWindow;
    private BoardRowPanel currentRowPanel;

    public GameboardScrollPane(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.setHorizontalScrollBarPolicy(31);
        this.setVerticalScrollBarPolicy(22);
        this.getVerticalScrollBar().setUnitIncrement(20);
        this.clearBoard();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    public void insertRow(int iteration) {
        this.insertRow(iteration, null, null, true);
    }

    public void insertRow(int iteration, RowState rowState, Feedback feedback, boolean interactive) {
        if (this.currentRowPanel != null) {
            this.currentRowPanel.setInteractive(false);
        }
        this.currentRowPanel = new BoardRowPanel(this, iteration, rowState, feedback, interactive);
        this.panel.add(this.currentRowPanel);
        this.revalidate();
    }

    public RowState getCurrentRow() {
        return this.currentRowPanel.getRow();
    }

    public void setFeedback(Feedback feedback) {
        this.currentRowPanel.setFeedback(feedback);
        this.currentRowPanel.repaint();
    }

    public void clearBoard() {
        this.panel = new FillingJPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(0, (int)super.getPreferredSize().getHeight());
            }
        };
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.setViewportView(this.panel);
    }

    public void setCorrect() {
        this.currentRowPanel.setInteractive(false);
        this.currentRowPanel.setCorrect();
    }
}

