/*
 * Decompiled with CFR 0.152.
 */
package pl.lodz.it.java.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import pl.lodz.it.java.dao.DAOException;
import pl.lodz.it.java.gui.MainWindow;
import pl.lodz.it.java.gui.SelectPlayerButtonsPanel;
import pl.lodz.it.java.model.Player;

public class SelectPlayerWindow
extends JFrame {
    private final JList<Player> playersList;
    private final SelectPlayerButtonsPanel buttonsPanel;
    private MainWindow mainWindow;

    public SelectPlayerWindow(final MainWindow mainWindow) throws DAOException {
        super("Select the player");
        this.mainWindow = mainWindow;
        this.setDefaultCloseOperation(0);
        this.setSize(400, 600);
        this.setLocationRelativeTo(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                if (mainWindow.getLogic().getCurrentPlayer() != null) {
                    SelectPlayerWindow.this.setVisible(false);
                } else {
                    SelectPlayerWindow.this.dispose();
                }
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.9;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.playersList = new JList();
        this.reloadPlayers();
        this.add(this.playersList, gbc);
        gbc.weighty = 0.1;
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.buttonsPanel = new SelectPlayerButtonsPanel(this);
        this.add((Component)this.buttonsPanel, gbc);
    }

    private void reloadPlayers() throws DAOException {
        Player[] players = this.mainWindow.getLogic().getDAO().getPlayers();
        DefaultListModel<Player> model = new DefaultListModel<Player>();
        this.playersList.setModel(model);
        for (Player p : players) {
            model.addElement(p);
        }
    }

    public void newPlayerButtonAction(ActionEvent event) {
        Object result = JOptionPane.showInputDialog(this, "Name", "New player", 3, null, null, "Player");
        if (result == null) {
            return;
        }
        try {
            this.mainWindow.getLogic().createPlayer(result.toString());
            this.reloadPlayers();
        }
        catch (DAOException e) {
            this.mainWindow.getExceptionHandler().handleException(e);
        }
    }

    public void selectPlayerAction(ActionEvent event) {
        Player player = this.playersList.getSelectedValue();
        if (player == null) {
            return;
        }
        this.mainWindow.setPlayer(player);
        this.mainWindow.setVisible(true);
        this.setVisible(false);
    }

    public void removePlayerAction(ActionEvent event) {
        Player player = this.playersList.getSelectedValue();
        int result = JOptionPane.showConfirmDialog(this.mainWindow, String.format("Are you sure to remove player %s?", player.getName()), "Confirm remove", 2, 0);
        if (result == 0) {
            try {
                this.mainWindow.getLogic().getDAO().removePlayer(player);
                this.reloadPlayers();
            }
            catch (DAOException e) {
                this.mainWindow.getExceptionHandler().handleException(e);
            }
        }
    }
}

