/*
 * Decompiled with CFR 0.152.
 */
package pl.lodz.it.java.logic;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import pl.lodz.it.java.dao.DAOException;
import pl.lodz.it.java.dao.IDAO;
import pl.lodz.it.java.logic.HelpLogic;
import pl.lodz.it.java.model.Feedback;
import pl.lodz.it.java.model.Gameplay;
import pl.lodz.it.java.model.Player;
import pl.lodz.it.java.model.RowState;

public class MastermindLogic {
    private HelpLogic helper;
    private Random random;
    private boolean gameInProgress = false;
    private int iteration = 1;
    private RowState solution;
    private boolean winner = false;
    private List<RowState> movesHistory;
    private Player currentPlayer;
    private IDAO dao;
    private Gameplay gameplay;

    public MastermindLogic(IDAO dao) {
        this.dao = dao;
        this.helper = new HelpLogic();
        this.random = new Random();
    }

    public void startNewGame() throws DAOException {
        this.gameInProgress = true;
        this.iteration = 1;
        this.winner = false;
        this.movesHistory = new ArrayList<RowState>();
        this.solution = new RowState(this.random.nextInt(this.helper.getNumberOfPermutations()));
        this.gameplay = this.dao.addGameplay(new Gameplay(this.currentPlayer, this.solution));
    }

    public void endGame() {
        if (!this.gameInProgress) {
            return;
        }
        this.gameInProgress = false;
        this.gameplay = null;
    }

    public Feedback checkRow(RowState guess) {
        assert (this.gameInProgress) : "Game not in progress. Start the game first";
        Feedback feedback = this.helper.provideFeedback(guess, this.solution);
        this.movesHistory.add(guess);
        try {
            this.dao.saveMove(this.gameplay, guess);
        }
        catch (DAOException dAOException) {
            // empty catch block
        }
        if (this.helper.isSolved(feedback)) {
            this.winner = true;
            this.gameInProgress = false;
        } else {
            ++this.iteration;
        }
        return feedback;
    }

    public boolean isGameInProgress() {
        return this.gameInProgress;
    }

    public RowState getSolution() {
        return this.solution;
    }

    public int getIteration() {
        return this.iteration;
    }

    public boolean isWinner() {
        return this.winner;
    }

    public List<RowState> getMovesHistory() {
        return this.movesHistory;
    }

    public Player getCurrentPlayer() {
        return this.currentPlayer;
    }

    public void setCurrentPlayer(Player currentPlayer) {
        this.currentPlayer = currentPlayer;
    }

    public Player createPlayer(String name) throws DAOException {
        return this.dao.createPlayer(name);
    }

    public IDAO getDAO() {
        return this.dao;
    }
}

