/*
 * Decompiled with CFR 0.152.
 */
package pl.lodz.it.java.dao;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import pl.lodz.it.java.dao.DAOException;
import pl.lodz.it.java.dao.IDAO;
import pl.lodz.it.java.model.Gameplay;
import pl.lodz.it.java.model.Guess;
import pl.lodz.it.java.model.Player;
import pl.lodz.it.java.model.RowState;

public class JdbcDAO
implements IDAO {
    private Connection connection;

    public JdbcDAO(String server, String database, String username, String password) throws DAOException {
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException cnfe) {
            throw new DAOException("MySQL driver not found", cnfe);
        }
        try {
            this.connection = DriverManager.getConnection("jdbc:mysql://" + server + "/" + database, username, password);
            System.out.println("Connected to database " + this.connection.getMetaData().getURL());
            this.createTables();
        }
        catch (SQLException sqle) {
            throw new DAOException("Error connecting to database", sqle);
        }
    }

    private void createTables() throws SQLException, DAOException {
        SQLWarning warning2;
        Throwable throwable;
        Statement stmt;
        DatabaseMetaData metaData = this.connection.getMetaData();
        ResultSet resultSet = metaData.getTables(null, null, "players", null);
        if (resultSet.next()) {
            return;
        }
        try {
            stmt = this.connection.createStatement();
            throwable = null;
            try {
                stmt.execute("CREATE TABLE players (id INT PRIMARY KEY NOT NULL AUTO_INCREMENT,name VARCHAR(20) NOT NULL UNIQUE);");
                warning2 = stmt.getWarnings();
                if (warning2 == null) {
                    System.out.println("Created table players");
                } else {
                    do {
                        System.out.println("Warning: " + warning2.getMessage());
                    } while ((warning2 = warning2.getNextWarning()) != null);
                }
            }
            catch (Throwable warning2) {
                throwable = warning2;
                throw warning2;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable warning2) {
                            throwable.addSuppressed(warning2);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new DAOException("Cannot create the table with players", e);
        }
        try {
            stmt = this.connection.createStatement();
            throwable = null;
            try {
                stmt.execute("CREATE TABLE distributions (id INT PRIMARY KEY NOT NULL AUTO_INCREMENT,solution INT NOT NULL UNIQUE );");
                warning2 = stmt.getWarnings();
                if (warning2 == null) {
                    System.out.println("Created table distributions");
                } else {
                    do {
                        System.out.println("Warning: " + warning2.getMessage());
                    } while ((warning2 = warning2.getNextWarning()) != null);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new DAOException("Cannot create the table with solutions", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Player[] getPlayers() throws DAOException {
        try (Statement stmt = this.connection.createStatement();){
            ResultSet result = stmt.executeQuery("SELECT id, name FROM players;");
            ArrayList<Player> players = new ArrayList<Player>();
            while (result.next()) {
                int id = result.getInt("id");
                String name = result.getString("name");
                players.add(new Player(id, name));
            }
            Player[] playerArray = players.toArray(new Player[players.size()]);
            return playerArray;
        }
        catch (SQLException e) {
            throw new DAOException("Cannot fetch players list", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Player createPlayer(String name) throws DAOException {
        try (PreparedStatement insertStmt = this.connection.prepareStatement("INSERT INTO players (name) VALUES (?);", 1);){
            insertStmt.setString(1, name);
            insertStmt.executeUpdate();
            ResultSet result = insertStmt.getGeneratedKeys();
            result.next();
            int id = result.getInt(1);
            Player player = new Player(id, name);
            return player;
        }
        catch (SQLException e) {
            throw new DAOException("Cannot create the player", e);
        }
    }

    @Override
    public void removePlayer(Player player) throws DAOException {
        try (PreparedStatement deleteStmt = this.connection.prepareStatement("DELETE FROM players WHERE id = ? AND name = ?;");){
            deleteStmt.setInt(1, player.getId());
            deleteStmt.setString(2, player.getName());
            deleteStmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new DAOException(String.format("Cannot remove the player %s [%d]", player.getName(), player.getId()), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Gameplay addGameplay(Gameplay gameplay) throws DAOException {
        try (PreparedStatement insertStmt = this.connection.prepareStatement("INSERT INTO gameplays (player, solution) VALUES (?, ?);", 1);){
            insertStmt.setInt(1, gameplay.getPlayer().getId());
            insertStmt.setInt(2, gameplay.getSolution().getState());
            ResultSet result = insertStmt.getGeneratedKeys();
            int id = result.getInt(1);
            Gameplay gameplay2 = new Gameplay(id, gameplay);
            return gameplay2;
        }
        catch (SQLException e) {
            throw new DAOException(String.format("Cannot save the game progress", new Object[0]), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Gameplay[] getGameplays(Player player) throws DAOException {
        try (PreparedStatement selectStmt = this.connection.prepareStatement("SELECT id, solution FROM gameplays WHERE player = ?;");){
            selectStmt.setInt(1, player.getId());
            ResultSet result = selectStmt.executeQuery();
            ArrayList<Gameplay> gameplays = new ArrayList<Gameplay>();
            while (result.next()) {
                int gameplayId = result.getInt("id");
                RowState solution = new RowState(result.getInt("solution"));
                ArrayList<Guess> moves = new ArrayList<Guess>();
                try (PreparedStatement movesStmt = this.connection.prepareStatement("SELECT move, guess FROM moves_history WHERE gameplay = ? ORDER BY move ASC;");){
                    movesStmt.setInt(1, gameplayId);
                    ResultSet movesSet = movesStmt.executeQuery();
                    while (movesSet.next()) {
                        int order = movesSet.getInt("move");
                        RowState guess = new RowState(movesSet.getInt("guess"));
                        moves.add(new Guess(order, guess));
                    }
                }
                Collections.sort(moves);
                RowState[] rowsHistory = (RowState[])moves.stream().map(Guess::getGuess).toArray(RowState[]::new);
                gameplays.add(new Gameplay(gameplayId, player, solution, rowsHistory));
            }
            Gameplay[] gameplayArray = gameplays.toArray(new Gameplay[gameplays.size()]);
            return gameplayArray;
        }
        catch (SQLException e) {
            throw new DAOException(String.format("Cannot fetch the list of player's [%d] %s games", player.getId(), player.getName()), e);
        }
    }

    @Override
    public void saveMove(Gameplay gameplay, RowState guess) throws DAOException {
    }
}

