/*
 * Decompiled with CFR 0.152.
 */
package pl.lodz.it.java.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Box;
import javax.swing.BoxLayout;
import pl.lodz.it.java.gui.CodePegPanel;
import pl.lodz.it.java.gui.FeedbackPanel;
import pl.lodz.it.java.gui.FillingJPanel;
import pl.lodz.it.java.gui.GameboardScrollPane;
import pl.lodz.it.java.gui.MainWindow;
import pl.lodz.it.java.gui.RowNumberPanel;
import pl.lodz.it.java.model.CodePeg;
import pl.lodz.it.java.model.Feedback;
import pl.lodz.it.java.model.RowState;

public class BoardRowPanel
extends FillingJPanel {
    private final RowNumberPanel numberPanel;
    private GameboardScrollPane gameboardScrollPane;
    private boolean interactive;
    private MainWindow mainWindow;
    private CodePegPanel[] pegPanels;
    private FeedbackPanel feedbackPanel;
    private boolean correct = false;

    public BoardRowPanel(GameboardScrollPane parent, int iteration, RowState rowState, Feedback feedback, boolean interactive) {
        this.gameboardScrollPane = parent;
        this.interactive = interactive;
        this.mainWindow = this.gameboardScrollPane.getMainWindow();
        this.numberPanel = new RowNumberPanel(this, iteration);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.numberPanel);
        this.pegPanels = new CodePegPanel[4];
        for (int i = 0; i < 4; ++i) {
            this.pegPanels[i] = new CodePegPanel(this, interactive);
            this.add(this.pegPanels[i]);
        }
        if (rowState != null) {
            CodePeg[] pegs = rowState.getPegs();
            for (int i = 0; i < this.pegPanels.length; ++i) {
                this.pegPanels[i].setPeg(pegs[i]);
            }
        }
        this.add(Box.createHorizontalGlue());
        this.feedbackPanel = new FeedbackPanel(this);
        this.feedbackPanel.setFeedback(feedback);
        this.add(this.feedbackPanel);
    }

    public BoardRowPanel(GameboardScrollPane parent, int iteration) {
        this(parent, iteration, null, null, true);
    }

    public GameboardScrollPane getGameboardScrollPane() {
        return this.gameboardScrollPane;
    }

    @Override
    public Dimension getPreferredSize() {
        int width = this.gameboardScrollPane.getPanel().getWidth();
        return new Dimension(width, (int)((double)width / 6.0 + 0.5));
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int cx = this.getWidth() - 1;
        int cy = this.getHeight() - 1;
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, cx, cy);
    }

    public RowState getRow() {
        CodePeg[] pegs = new CodePeg[this.pegPanels.length];
        for (int i = 0; i < pegs.length; ++i) {
            pegs[i] = this.pegPanels[i].getPeg();
            if (pegs[i] != null) continue;
            return null;
        }
        return new RowState(pegs);
    }

    public void setFeedback(Feedback feedback) {
        this.feedbackPanel.setFeedback(feedback);
    }

    public void setInteractive(boolean interactive) {
        if (this.interactive == interactive) {
            return;
        }
        this.interactive = interactive;
        for (int i = 0; i < this.pegPanels.length; ++i) {
            this.pegPanels[i].setInteractive(interactive);
        }
    }

    public void setCorrect() {
        this.correct = true;
        this.numberPanel.setCorrect();
    }
}

