/*
 * Decompiled with CFR 0.152.
 */
package pl.lodz.it.java.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import pl.lodz.it.java.gui.BoardRowPanel;
import pl.lodz.it.java.gui.FillingJPanel;
import pl.lodz.it.java.model.CodePeg;

public class CodePegPanel
extends FillingJPanel
implements MouseListener {
    private BoardRowPanel rowPanel;
    private CodePeg peg = null;
    private boolean interactive;
    private boolean mouseInside;
    private Stroke outlineStroke = new BasicStroke(3.0f);

    public CodePegPanel(BoardRowPanel rowPanel, boolean interactive) {
        this.rowPanel = rowPanel;
        this.setInteractive(interactive);
    }

    @Override
    public Dimension getPreferredSize() {
        int dim = this.rowPanel.getHeight();
        return new Dimension(dim, dim);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHints(rh);
        super.paint(g2);
        int cx = this.getWidth();
        int cy = this.getHeight();
        int x = (int)((double)cx * 0.1);
        int y = (int)((double)cy * 0.1);
        Color fillColor = this.rowPanel.getGameboardScrollPane().getMainWindow().pegToColor(this.peg);
        g2.setColor(fillColor);
        g2.fillOval(x, y, cx -= 2 * x, cy -= 2 * y);
        if (this.mouseInside) {
            Stroke defaultStroke = g2.getStroke();
            g2.setColor(Color.BLACK);
            g2.setStroke(this.outlineStroke);
            g2.drawOval(x, y, cx, cy);
            g2.setStroke(defaultStroke);
        }
        g2.setColor(Color.BLACK);
        g2.drawRect(0, 0, this.getWidth(), this.getHeight());
    }

    public CodePeg getPeg() {
        return this.peg;
    }

    public void setPeg(CodePeg peg) {
        this.peg = peg;
        this.callRepaint();
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
        if (interactive) {
            this.addMouseListener(this);
        } else {
            this.removeMouseListener(this);
            this.mouseInside = false;
        }
    }

    private void setMouseInside(boolean inside) {
        this.mouseInside = inside;
        this.callRepaint();
    }

    public boolean isMouseInside() {
        return this.mouseInside;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        CodePeg[] colors = CodePeg.values();
        if (this.peg == null) {
            this.setPeg(colors[0]);
        } else {
            int button = e.getButton();
            int i = this.peg.getValue();
            if (button == 1) {
                ++i;
                i %= colors.length;
            } else if (button == 3) {
                i = i > 0 ? i - 1 : colors.length - 1;
            } else {
                return;
            }
            this.setPeg(colors[i]);
        }
    }

    private void callRepaint() {
        this.rowPanel.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setMouseInside(true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setMouseInside(false);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

