/*
 * Decompiled with CFR 0.152.
 */
package pl.lodz.it.java.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import pl.lodz.it.java.gui.BoardRowPanel;

public class RowNumberPanel
extends JPanel {
    private BoardRowPanel rowPanel;
    private int iteration;
    private boolean correct = false;

    public RowNumberPanel(BoardRowPanel rowPanel, int iteration) {
        this.rowPanel = rowPanel;
        this.iteration = iteration;
    }

    @Override
    public Dimension getPreferredSize() {
        int dim = this.rowPanel.getHeight();
        return new Dimension(dim, dim);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        g2.setRenderingHints(rh);
        super.paint(g2);
        int cx = this.getWidth();
        int cy = this.getHeight();
        if (this.correct) {
            g2.setColor(Color.GREEN);
        } else {
            g2.setColor(Color.LIGHT_GRAY);
        }
        g2.fillRect(0, 0, cx, cy);
        Font numFont = new Font("Arial", 1, cy / 2);
        g2.setFont(numFont);
        g2.setColor(Color.BLACK);
        FontMetrics fm = g2.getFontMetrics();
        String numStr = String.valueOf(this.iteration);
        int fcx = (int)fm.getStringBounds(numStr, g2).getWidth();
        int fcy = fm.getHeight();
        g2.drawString(numStr, (cx - fcx) / 2, (cy - fcy) / 2 + fm.getAscent());
    }

    public void setCorrect() {
        this.correct = true;
    }
}

