/*
 * Decompiled with CFR 0.152.
 */
package pl.lodz.it.java.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import pl.lodz.it.java.gui.BoardRowPanel;
import pl.lodz.it.java.gui.FillingJPanel;
import pl.lodz.it.java.model.Feedback;

public class FeedbackPanel
extends FillingJPanel {
    private BoardRowPanel rowPanel;
    private Feedback feedback = null;
    private Color bgColor = new Color(0x808080);

    public FeedbackPanel(BoardRowPanel rowPanel) {
        this.rowPanel = rowPanel;
    }

    @Override
    public Dimension getPreferredSize() {
        int dim = this.rowPanel.getHeight();
        return new Dimension(dim, dim);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHints(rh);
        super.paint(g2);
        g2.setColor(this.bgColor);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.feedback == null) {
            return;
        }
        int cx = this.getWidth() / 2;
        int cy = this.getHeight() / 2;
        int black = this.feedback.getBlack();
        int white = this.feedback.getWhite();
        int x = (int)((double)cx * 0.1);
        int y = (int)((double)cy * 0.1);
        int ncx = cx - 2 * x;
        int ncy = cy - 2 * y;
        block0: for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                Color color = null;
                if (black > 0) {
                    color = Color.BLACK;
                    --black;
                } else if (white > 0) {
                    color = Color.WHITE;
                    --white;
                }
                if (color == null) break block0;
                g2.setColor(color);
                g2.fillOval(x + j * cx, y + i * cy, ncx, ncy);
            }
        }
    }

    public Feedback getFeedback() {
        return this.feedback;
    }

    public void setFeedback(Feedback feedback) {
        this.feedback = feedback;
        this.invalidate();
    }
}

