/*
 * Decompiled with CFR 0.152.
 */
package pl.lodz.it.java.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import pl.lodz.it.java.dao.DAOException;
import pl.lodz.it.java.dao.MemoryDAO;
import pl.lodz.it.java.gui.ButtonsPanel;
import pl.lodz.it.java.gui.GUIExceptionHandler;
import pl.lodz.it.java.gui.GameMenuBar;
import pl.lodz.it.java.gui.GameboardScrollPane;
import pl.lodz.it.java.gui.SelectPlayerWindow;
import pl.lodz.it.java.logic.MastermindLogic;
import pl.lodz.it.java.model.CodePeg;
import pl.lodz.it.java.model.Feedback;
import pl.lodz.it.java.model.Player;
import pl.lodz.it.java.model.RowState;

public class MainWindow
extends JFrame {
    private final MastermindLogic logic;
    private SelectPlayerWindow selectPlayerWindow;
    private final GUIExceptionHandler exceptionHandler = new GUIExceptionHandler(this);
    private GameMenuBar menuBar;
    private GameboardScrollPane gameboardScrollPane;
    private ButtonsPanel buttonsPanel;
    private Player player;

    public MainWindow(MastermindLogic logic) {
        super("Mastermind - Advanced Programming Course in Java");
        this.logic = logic;
        try {
            this.selectPlayerWindow = new SelectPlayerWindow(this);
        }
        catch (DAOException e) {
            this.exceptionHandler.handleException(e);
            this.dispose();
        }
        this.setDefaultCloseOperation(0);
        this.setSize(400, 700);
        this.setLocationRelativeTo(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (MainWindow.this.confirmEnding()) {
                    MainWindow.this.setDefaultCloseOperation(3);
                    MainWindow.this.dispose();
                }
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.95;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.gameboardScrollPane = new GameboardScrollPane(this);
        this.add((Component)this.gameboardScrollPane, gbc);
        gbc.weighty = 0.05;
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.buttonsPanel = new ButtonsPanel(this);
        this.add((Component)this.buttonsPanel, gbc);
        this.menuBar = new GameMenuBar(this);
        this.setJMenuBar(this.menuBar);
        this.selectPlayerWindow.setVisible(true);
    }

    private boolean confirmEnding() {
        if (!this.logic.isGameInProgress()) {
            return true;
        }
        int result = JOptionPane.showConfirmDialog(this, "Are you sure to end this game?", "Game in progress", 0, 3);
        return result == 0;
    }

    public static void main(String[] args) throws DAOException {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!info.getName().equals("Nimbus")) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
            new MainWindow(new MastermindLogic(new MemoryDAO()));
        }
        catch (Exception e) {
            GUIExceptionHandler.handleStatic(e);
        }
    }

    public MastermindLogic getLogic() {
        return this.logic;
    }

    public void pressCloseButton() {
        WindowEvent wev = new WindowEvent(this, 201);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
    }

    public void startNewGame() {
        if (this.confirmEnding()) {
            try {
                this.logic.startNewGame();
                this.gameboardScrollPane.clearBoard();
                this.gameboardScrollPane.insertRow(this.logic.getIteration());
                this.buttonsPanel.setEnabled(true);
            }
            catch (DAOException e) {
                this.exceptionHandler.handleException(e);
            }
        }
    }

    public void checkRow() {
        RowState guess = this.gameboardScrollPane.getCurrentRow();
        if (guess == null) {
            return;
        }
        Feedback feedback = this.logic.checkRow(guess);
        this.gameboardScrollPane.setFeedback(feedback);
        if (this.logic.isWinner()) {
            this.gameboardScrollPane.setCorrect();
            this.buttonsPanel.setEnabled(false);
            JOptionPane.showMessageDialog(this, String.format("Congratulations! You guessed after %d tries.", this.logic.getIteration()), "Congratulations", 1);
        } else {
            this.gameboardScrollPane.insertRow(this.logic.getIteration());
        }
    }

    public Color pegToColor(CodePeg peg) {
        if (peg != null) {
            switch (peg) {
                case RED: {
                    return Color.RED;
                }
                case GREEN: {
                    return Color.GREEN;
                }
                case BLUE: {
                    return Color.BLUE;
                }
                case YELLOW: {
                    return Color.YELLOW;
                }
                case VIOLET: {
                    return new Color(0xC000C0);
                }
                case BROWN: {
                    return new Color(0x800000);
                }
            }
        }
        return Color.GRAY;
    }

    public void showAboutDialog() {
        JOptionPane.showMessageDialog(this, "Mastermind\nPiotr Marci\u0144czyk (C) 2015\nLodz University of Technology\nAdvanced Programming Course in Java", "About", 1);
    }

    public GUIExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }
}

